{$f+,s-,i-,g+}
{$define extendM1}

{$define vga256}
{$define vgaTrueColor}
{_$define HercMono}
unit fgraph;
interface
var maxgX,maxgY,colorPlanes:word;
    DriverName:^String;
    WmaxgX,WmaxgY,WmingX,WmingY:word;
    BkColor,Color,transparent:Longint;
    Xposition,Yposition:integer;

type Vmode=record
	SizeX,SizeY:Word;
        BiosMode:Word;
        end;

    ViewPortType = record
   	x1, y1, x2, y2 : integer;
	Clip           : Boolean;
	end;

    RGBRec = record
	RedVal, GreenVal, BlueVal: Byte;
    end;


Function InitGraph(driver,mode:integer;path:String):Byte;
Procedure RestoreCrtMode;
Procedure CloseGraph;
Function GetDriverName : string;

Procedure ClearViewPort;
Procedure PutPixel(x,y:integer;NewColor:Longint);
Procedure SetViewPort(x1, y1, x2, y2: Integer; Clip: Boolean);
Function ImageSize(x1, y1, x2, y2: Integer): Word;
Procedure GetImage(x1, y1, x2, y2: Integer; var BitMap);
Procedure PutImage(X, Y: Integer; var BitMap; BitBlt: Word);
Procedure GetViewSettings(var ViewPort: ViewPortType);


Procedure MoveTo(X, Y: Integer);
Procedure MoveRel(Dx, Dy: Integer);
Procedure LineTo(X, Y: Integer);
Procedure LineRel(Dx, Dy: Integer);
Procedure Rectangle(x1, y1, x2, y2: Integer);


Procedure SetTextStyle(const FontName:string;Direction:Word;Size:Word);
Procedure Outtext(const s:string);
Procedure OuttextXY(X,Y:integer;const s:string);
Function TextWidth(const TextString: string): Word;
Function TextHeight(const TextString: string): Word;


Procedure SetColor(NewColor:Word);
Function GetColor: Word;
Procedure SetBkColor(NewColor:Word);
Function GetBkColor: Word;
Procedure SetTransparentColor(NewTColor:Word);
Function GetTransparentColor:Word;
Procedure SetRGBPalette(ColorRegNum:word;Red,Green,Blue:byte);
Procedure SetRGBBlock(StartColor,NumColors:word;var data);
Function GetMaxColor:Longint;
Function GetMaxX:Word;
Function GetMaxY:Word;
Function GetX:Word;
Function GetY:Word;


Procedure SetVgaPage;
Procedure _plot(x,y:integer); 	{meni AX,DI,DX}
Procedure _Line(x1,y1,x2,y2:integer);
Procedure _Circle(xs,ys,r:integer);
Procedure _Bar(X0,Y0,X1,Y1:integer);
Procedure _Bitmap(x,y,ddx,ddy:integer;bmp:pointer);
Procedure _BitmapT(x,y,ddx,ddy:integer;bmp:pointer);


Procedure NoOp0;
Function  NoOpF1(M:Integer):integer;
Procedure NoOp2(x,y:integer);
Function  NoOpF2(x,y:integer):Longint;
Procedure NoOp3(xs,ys,r:integer);
Procedure NoOp4(x1,y1,x2,y2:integer);
Procedure NoOp5(x,y,ddx,ddy:integer;p:pointer);




const SetGraphMode:Function(Mode: Integer):integer=NoOpF1;
      ClearDevice:Procedure=NoOp0;
      Plot:Procedure (x,y:integer)=NoOp2;
      GetPixel:Function(x,y:integer):Longint=NoOpF2;
      Circle:Procedure (xs,ys,r:integer)=NoOp3;
      Line:Procedure (x1,y1,x2,y2:integer)=NoOp4;
      Bar:Procedure (x0,y0,x1,y1:integer)=NoOp4;
      Bitmap:Procedure(x,y,ddx,ddy:integer;bmp:pointer)=NoOp5;

      SetGrPage:Procedure=NoOp0;

      GrPath:String[80]='';
      GetGraphMode:integer=-1;


      Vmodes:array[0..15] of vmode=
	((SizeX:320;SizeY:200;BiosMode:$13),		{0 320x200}
	 (SizeX:640;SizeY:350;BiosMode:$2D),
	 (SizeX:640;SizeY:400;BiosMode:$2F),
	 (SizeX:640;SizeY:400;BiosMode:$5E),
	 (SizeX:640;SizeY:480;BiosMode:$2E),
	 (SizeX:640;SizeY:480;BiosMode:$201),
	 (SizeX:640;SizeY:480;BiosMode:$101),   	{3 640x480}
	 (SizeX:640;SizeY:640;BiosMode:$5F),
	 (SizeX:640;SizeY:640;BiosMode:$5C),		{5 640x640}
	 (SizeX:800;SizeY:600;BiosMode:$30),
	 (SizeX:800;SizeY:600;BiosMode:$203),
	 (SizeX:800;SizeY:600;BiosMode:$103),		{7 800x600}
	 (SizeX:1024;SizeY:768;BiosMode:$38),
	 (SizeX:1024;SizeY:768;BiosMode:$205),
	 (SizeX:1024;SizeY:768;BiosMode:$105),		{9 1024x768}
{	 (SizeX:1280;SizeY:1024;BiosMode:$107),{}
	 (SizeX:1280;SizeY:1024;BiosMode:$3F));		{10 1280x1024}
      Vrezimy:array[0..5] of byte=(0,6,8,11,14,15);{indexy Vmodes}
      GrNameVGA256:string[15]='SVGA driver 256';

      VmodesTC:array[0..3] of vmode=
	((SizeX:640;SizeY:480;BiosMode:$2E),
	 (SizeX:640;SizeY:480;BiosMode:$212),
	 (SizeX:640;SizeY:480;BiosMode:$112),		{0 640x480}
	 (SizeX:800;SizeY:600;BiosMode:$115));		{1 800x600}
      VrezimyTC:array[0..1] of byte=(2,3);	{indexy Vmodes}
      GrNameVGATC:string[22]='SVGA driver True Color';



      GrNameHerc:string[12]='Hercules mono';

{---------Graph constants---------}
      DefaultFont='';
      TriplexFont='trip';
      SmallFont='scri';
      SansSerifFont='sans';
      GothicFont='goth';
      EuroFont='euro';

      HorizDir=0;		{ Orient left to right}
      VertDir=1;		{ Orient bottom to top}

	NormalPut =   0;	{ MOV }
	CopyPut	  =   0;	{ MOV }
	XORPut	  =   1;	{ XOR }
	OrPut	  =   2;	{ OR  }
	AndPut	  =   3;	{ AND }
	NotPut	  =   4;	{ NOT }

	Detect   =    0;	{Requests autodetection}
	HercMono =    7;
	SVGA256  =   11;
	SVGATC   =   12;


implementation
{$ifdef DPMI}var VideoSegment:Word absolute SegA000;
{$else}    const VideoSegment=$A000;{$endif}

type	TFontHeader=record
		Name:array[0..$7F] of char;
		Flag:char;
		CharNumber:Word;
                Undefined:Byte;
		FirstCharValue:Char;
		StrokeDefOffs:Word;	{(8+3n)}
		ScanFlag:Byte;		{(normally 0)}
		D_Orig_top:Byte;
		D_Orig_baseline:Byte;
                D_Orig_bottom:Byte;
                Undefined2:Longint;
                U2:Byte;
	    end;

         PInternalFont=^TInternalFont;
         TInternalFont=record
                ShName:String[8];
         	OffsTable:array[0..255]of word;
                WidthTable:array[0..255]of byte;
		D_Orig_top:Byte;
		D_Orig_baseline:Byte;
                D_Orig_bottom:Byte;
                OpTblSize:Word;
		OpTable:^Word;
              end;

Function LoadFont(name:String;font:PInternalFont):Boolean;
var Hf:TfontHeader;
     F:file;
     i:Word;
     p1,p2:Longint;
begin
  LoadFont:=False;
  assign(f,name);
  reset(f,1);
  if IoResult<>0 then exit;
  fillchar(Font^.OffsTable,sizeof(Font^.OffsTable),0);
  blockRead(f,Hf,sizeof(Hf));
  Font^.D_Orig_top:=Hf.D_Orig_top;
  Font^.D_Orig_baseline:=Hf.D_Orig_baseline;
  Font^.D_Orig_bottom:=Hf.D_Orig_bottom;

  blockRead(f,Font^.OffsTable[ord(Hf.FirstCharValue)],Hf.CharNumber*2);
  blockRead(f,Font^.WidthTable[ord(Hf.FirstCharValue)],Hf.CharNumber);

  Font^.OpTblSize:=FileSize(F)-filepos(f);
  GetMem(Font^.OpTable,Font^.OpTblSize);
  blockRead(f,Font^.OpTable^,Font^.OpTblSize);

  close(f);
  LoadFont:=IOresult=0;
end;

const Fonts:array[1..10] of PinternalFont=(nil,nil,nil,nil,nil,nil,nil,nil,nil,nil);
      ActualFont:PinternalFont=nil;
var TextX,TextY:integer;
    SizeTX,SizeTY:integer;


Procedure PutChar(c:char);
var w:^Word;
    s:Word;
    Action:Byte;
    Lx,Ly,x,y:integer;
begin
 if ActualFont=nil then exit;
 pointer(w):=ActualFont^.OpTable;
 inc(w,ActualFont^.OffsTable[ord(c)] shr 1);

 Lx:=TextX;Ly:=TextY;
 while Lo(w^)>127 do
   begin
   y:=Hi(w^) and $7F;
   if y>64 then y:=y or $FF80;
   y:=SizeTY*y+TextY;
   x:=Lo(W^) and $7F;
   if x>64 then x:=x or $FF80;
   x:=SizeTX*x+TextX;

   if Hi(w^)>127 then Line(Lx,Ly,x,y);
   Lx:=X;Ly:=Y;
   inc(w);
   end;
 inc(TextX,ActualFont^.WidthTable[ord(c)]*abs(SizeTX));
 if TextX>MaxGX then
 	begin
        TextX:=0;
        inc(TextY,ActualFont^.D_Orig_top*abs(SizeTY));
        end;
end;


{---------------vzdy pouzitelne funkce a procedury----------------------}
Function GetDriverName : string;
begin
 GetDriverName:='';
 if DriverName=nil then exit;
 GetDriverName:=DriverName^;
end;

procedure GetViewSettings(var ViewPort: ViewPortType);
begin
end;


procedure SetViewPort(x1, y1, x2, y2: Integer; Clip: Boolean);
begin
end;

function ImageSize(x1, y1, x2, y2: Integer): Word;
begin
ImageSize:=0;
end;

procedure GetImage(x1, y1, x2, y2: Integer; var BitMap);
begin
end;

procedure PutImage(X, Y: Integer; var BitMap; BitBlt: Word);
begin
end;

Procedure Outtext(const s:string);
var i:Byte;
begin
 for i:=1 to length(s) do putchar(s[i]);
end;

Procedure OuttextXY(X,Y:integer;const s:string);
var i:Byte;
begin
 TextX:=X;
 TextY:=Y;
 for i:=1 to length(s) do putchar(s[i]);
end;

Function TextWidth(const TextString: string): Word;
var i:Byte;
    Width:Word;
begin
 TextWidth:=8;
 Width:=0;
 if ActualFont=nil then exit;
 for i:=1 to length(TextString) do
 	Width:=Width+ActualFont^.WidthTable[ord(TextString[i])]*abs(SizeTX);
 TextWidth:=Width;
end;

Function TextHeight(const TextString: string): Word;
begin
 TextHeight:=8;
 if ActualFont=nil then exit;
 TextHeight:=ActualFont^.D_Orig_top*abs(SizeTY);
end;


Procedure SetTextStyle(const FontName:string;Direction:Word;Size:Word);
var i:byte;
begin
 SizeTX:=Size;SizeTY:=-Size;
 for i:=1 to 10 do
 	begin
 	if Fonts[i]<>nil then if fontName=Fonts[i]^.ShName then
		begin	{font nalezen v tabulce}
                ActualFont:=Fonts[i];
                exit;
		end;
        end;
 for i:=1 to 10 do
 	begin
 	if (Fonts[i]=nil)or(i=10) then
		begin	{font nutno nahrat}
                new(fonts[i]);
                fonts[i]^.OpTable:=nil;
                ActualFont:=Fonts[i];

                if not(LoadFont(FontName+'.CHR',fonts[i])) then
                	if not(LoadFont(GrPath+FontName+'.CHR',fonts[i])) then
				begin
                                ActualFont:=nil;
                                dispose(Fonts[i]);
                                Fonts[i]:=nil;
                                end;
                Fonts[i]^.ShName:=FontName;
                exit;
		end;
        end;
end;


Procedure MoveTo(X, Y: Integer);
begin
 Xposition:=X;Yposition:=Y;
end;

Procedure MoveRel(Dx, Dy: Integer);
begin
 inc(Xposition,Dx);
 inc(Yposition,Dy);
end;


Procedure LineRel(Dx, Dy: Integer);
begin
 Line(Xposition,Yposition,Xposition+Dx,Yposition+Dy);
 inc(Xposition,Dx);
 inc(Yposition,Dy);
end;

Procedure LineTo(X, Y: Integer);
begin
 Line(Xposition,Yposition,X,Y);
 Xposition:=X;
 Yposition:=Y;
end;

procedure Rectangle(x1, y1, x2, y2: Integer);
begin
 line(x1,y1,x2,y1);
 line(x1,y2,x2,y2);
 line(x1,y1,x1,y2);
 line(x2,y1,x2,y2);
end;


Procedure ClearViewPort;
begin
 bar(WmingX,WmingY,WmaxgX,WmaxgY);
end;

Function GetMaxColor:Longint;
begin
 GetMaxColor:=longint(1) shl ColorPlanes;
end;

Function GetMaxX:Word; assembler;
asm
	mov	ax,MaxGx
end;

Function GetMaxY:Word; assembler;
asm
	mov	ax,MaxGy
end;

Function GetX:Word; assembler;
asm
	mov	ax,Xposition
end;

Function GetY:Word; assembler;
asm
	mov	ax,YPosition
end;


Procedure SetColor(NewColor:Word); assembler;
asm
	mov	ax,NewColor
	mov	word ptr Color,ax
end;

Function GetColor: Word; assembler;
asm
	mov	ax,word ptr Color
end;

Procedure SetBkColor(NewColor:Word); assembler;
asm
	mov	ax,NewColor
	mov	word ptr BkColor,ax
end;

Function GetBkColor: Word; assembler;
asm
	mov	ax,word ptr BkColor
end;

Procedure SetTransparentColor(NewTColor:Word);
begin
 transparent:=NewTColor;
 if @bitmap<>@Noop5 then bitmap:=_bitmapT;
end;

Function GetTransparentColor: Word; assembler;
asm
	mov	ax,word ptr transparent
end;

Procedure PutPixel(x,y:integer;NewColor:Longint); assembler;
asm
	mov	ax,word ptr NewColor		{color ze zasobniku}
	mov     word ptr Color,ax
        mov	ax,word ptr NewColor+2
        mov     word ptr Color+2,ax
	mov	ax,x
	push	ax
        mov	ax,y
        push	ax
	Call    Plot
end;


Procedure LinePas(x1,y1,x2,y2:integer);
var dx,dy,p,k1,k2,incr:integer;
begin
dx:=abs(x1-x2);
dy:=abs(y1-y2);
if dx>dy then
  begin
  if(x1>x2) then
  	begin
        p:=x1;x1:=x2;x2:=p;
        p:=y1;y1:=y2;y2:=p;
        end;
  if(y2>y1) then incr:=+1
  	    else incr:=-1;
  p:=2*dy-dx;
  k1:=2*dy;
  k2:=2*(dy-dx);
  Plot(x1,y1);
  while(x1<x2) do
	 begin
         inc(x1);
         if(p<0) then p:=p+k1
        	 else begin
                      inc(y1,incr);
		      p:=p+k2;
		      end;
 	 Plot(x1,y1);
         end;
  end
  else begin
  if(y1>y2) then
  	begin
        p:=x1;x1:=x2;x2:=p;
        p:=y1;y1:=y2;y2:=p;
        end;
  if(x2>x1) then incr:=+1
  	    else incr:=-1;
  p:=2*dx-dy;
  k1:=2*dx;
  k2:=2*(dx-dy);
  Plot(x1,y1);
  while(y1<y2) do
	 begin
         inc(y1);
         if(p<0) then p:=p+k1
        	 else begin
                      inc(x1,incr);
		      p:=p+k2;
		      end;
 	 Plot(x1,y1);
         end;
  end;
end;


{------------------------------}
Procedure NoOp0;
begin end;
Function  NoOpF1(M:Integer):integer;
begin end;
Procedure NoOp2(x,y:integer);
begin end;
Function NoOpF2(x,y:integer):Longint;
begin end;
Procedure NoOp3(xs,ys,r:integer);
begin end;
Procedure NoOp4(x1,y1,x2,y2:integer);
begin end;
Procedure NoOp5(x,y,ddx,ddy:integer;p:pointer);
begin end;




{>>>>>>>>>>>>>>>>-Procedury zavisle na systemu-<<<<<<<<<<<<<<<<}
const OldPage:Word=$FFFF;
      PagingReg=$3ce;
Procedure SetVgaPage;	assembler;	{vstup Dx - cislo stranky}
asm                                     {meni BX,DX}
	mov	bx,ax
	mov	OldPage,Dx
	shl	dx,4
	mov	ah,dl
	mov	al,$09
	mov	dx,$3CE		{registr sequenceru}
	out	dx,ax
	mov	ax,bx
end;

Procedure SetSVgaPage;	assembler;	{vstup Dx - cislo stranky}
asm              			{meni BX,DX}
	push	ax
	mov	OldPage,Dx
	mov	ax,4f05h
        mov	bx,0
        int	10h
        pop	ax
end;


Procedure SetRGBPalette(ColorRegNum:word;Red,Green,Blue:byte); assembler;
asm
     MOV        AH,$10
     MOV        AL,$10
     MOV        BX,ColorRegNum
     MOV        DH,BYTE PTR red
     MOV        CH,BYTE PTR green
     MOV        CL,BYTE PTR blue
     INT        $10
end;

Procedure SetRGBBlock(StartColor,NumColors:word;var data); assembler;
asm
     MOV        AH,$10
     MOV        AL,$12
     MOV        BX,StartColor
     MOV        CX,NumColors
     PUSH	ES
     LES	DX,Data
     INT        $10
     POP	ES
end;
{--------------------------------------------------------------}
Function SetVideoMode(VMode:Word):Word;	assembler;
asm
	mov	ax,VMode
	or	ah,ah
	jz	@StdVga

	mov	bx,ax		{Inicializace SVGA rezimu podle VESA}
	mov	ax,$4F02
	int	10h
	cmp	ax,$004F
	jmp	@cnt

@StdVga:int	10h		{Inicializace VGA rezimu}
	mov	ah,$0F			{zjisti aktualni rezim}
	int	10h
	cmp	al,byte ptr Vmode

@cnt:	mov	ax,$0FFFF
	jne	@@modfl		{neuchytil se - error}

	xor	ax,ax
@@modfl:
end;



{$ifdef vga256}
{>>>>>>>>>>>>>>-Procedury zavisle na rozliseni obrazovky vga256 -<<<<<<<<<<<<}
Procedure _ClearDevice265; far; assembler;	{meni AX,DI,DX}
label loopage,nezbyt;
asm
	push	es
	cld
	mov	ax,VideoSegment
        mov	es,ax

	mov	ax,maxgY
        mul	maxgX
        mov     cx,ax		{zacneme posledni strankou (neuplnou)}
        mov     si,0
        jcxz	nezbyt
        mov	si,cx
        and	si,3
	shr	cx,2

LooPage:
{$ifdef extendM1}
        mov	ax,dx
	call	SetGrPage
        mov	dx,ax
{$endif}
	mov	al,byte ptr BkColor
        mov	ah,al

	mov	di,ax
db 66h;	shl	ax,16
	mov	ax,di
        mov	di,0
db 66h;	rep stosw
        mov	cx,si
	rep stosb
nezbyt:	mov	cx,$4000
	mov	si,0
{$ifdef extendM1}
        dec	dl
	jns	loopage
{$endif}
	pop	es
end;


Procedure _plot(x,y:integer); assembler;	{meni AX,DI,DX}
label mimo;
asm
	push	es
	mov	ax,VideoSegment
        mov	es,ax

        mov	ax,y
        cmp	ax,maxgY
        jg	mimo
	cmp	ax,0
        jl	mimo
        mov	di,x
	cmp	di,maxgX
        jg	mimo
        cmp	di,0
        jl	mimo
        mul	maxgX
	add	di,ax
        adc	dx,0

{$ifdef extendM1}
        cmp	dx,OldPage
        je      @preskoc
	call	SetGrPage
@preskoc:
{$endif}
        mov	ah,byte ptr color
        mov	byte ptr es:di,ah
mimo:	pop	es
end;

Function _GetPixel(X,Y: Integer): Longint; assembler;	{meni AX,DI,DX}
label mimo;
asm
	push	es
	mov	ax,VideoSegment
	mov	es,ax

        mov	al,byte ptr color
        mov	bx,y
        cmp	bx,maxgY
        jg	mimo
	cmp	bx,0
        jl	mimo
        mov	di,x
        cmp	di,maxgX
        jg	mimo
	cmp	di,0
        jl	mimo
        mov	ax,bx
	mul	maxgX
        add	di,ax
        adc	dx,0

{$ifdef extendM1}
	cmp	dx,OldPage
        je      @preskoc
	call	SetGrPage
@preskoc:
{$endif}
        mov	al,byte ptr es:di
mimo:   mov	ah,0
	mov	dx,0
	pop	es
end;

Procedure _Line(x1,y1,x2,y2:integer);
var incr,k1,k2,offs:integer;
label nekordx,nekordy,verticl,
	ho_kb,ho_plus,ho_lop,hol_pl,hol_zpl,neprtok,dobrekl,ho_zlop,lineend,ho_nky,ho_lopk,hop_pl,ho_cor,ho_klop,ho_pkla,ho_zlky,
	ve_kb,ve_plus,ve_lop,vel_pl,ve_lopk,ve_nky,ve_cor,vep_pl,vdobrek,ve_fnky,ve_flop,ve_fcor,vel_fpl,vdbsk,ve_fmx,vel_ffp,
        prohod,kory0,korYMax,korX0,korxMax;
begin
	asm
        push	es
	mov	ax,VideoSegment
        mov	es,ax

        jmp	@@locl1
kory0:  cmp	cx,dx		{korekce pro prusecik s primkou y=0}
	je	lineend
	jg	prohod		;{prohod aby bylo y1<y2}
	or	dx,dx		{vetsi y2 nesmi byt zaporne}
	js	lineend
	sub	dx,cx		{v CX je y2-y1}
        mov	cx,dx
	imul	y1
        mov	si,ax
        mov	di,dx		{v DI:SI je x2*y1}
	mov	ax,bx
        imul	y2		{v DX:AX je x1*y2}
        sub	ax,si
        sbb	dx,di
        idiv	cx
	mov	x1,ax
        mov	y1,0
        jmp	@@locl1
koryMax:cmp	cx,dx		{korekce pro prusecik s primkou y=maxgY}
	je	lineend
        jg	prohod		;{prohod aby bylo y1<y2}
	cmp	cx,MaxGy		{vetsi y2 nesmi byt zaporne}
	jge	lineend
	sub	dx,cx		{v CX je y2-y1}
	mov	cx,dx
	imul	y1
	mov	si,ax
        mov	di,dx		{v DI:SI je x2*y1}
        mov	ax,bx
	sub	ax,x2
	mov	dx,MaxGy
	dec	dx
	imul	dx
	add	si,ax
	adc	di,dx
	mov	ax,bx
	imul	y2		{v DX:AX je x1*y2}
	sub	ax,si
	sbb	dx,di
	idiv	cx
	mov	x2,ax
	mov	dx,maxGy
	dec	dx
        mov	y2,dx
        jmp	@@locl1
korx0:  cmp	bx,ax		{korekce pro prusecik s primkou x=0}
	je	lineend
        jg	prohod		;{prohod aby bylo x1<x2}
	or	ax,ax		{vetsi x2 nesmi byt zaporne}
	js	lineend
        mov	cx,ax
	sub	cx,bx		{v CX je x2-x1}
        xchg	ax,bx
	imul	y2
        mov	si,ax
        mov	di,dx		{v DI:SI je x2*y1}
        mov	ax,bx
        imul	y1		{v DX:AX je x1*y2}
        sub	ax,si
	sbb	dx,di
        idiv	cx
        mov	x1,0
        mov	y1,ax
        jmp	@@locl1
korxMax:cmp	bx,ax		{korekce pro prusecik s primkou x=MaxGx}
	je	lineend
        jg	prohod		;{prohod aby bylo x1<x2}
	cmp	bx,MaxgX	{mensi x2 nesmi byt vetsi nez MaxGx}
	jge	lineend
        sub	cx,dx
	mov	dx,cx		{v DX je y2-y1}
        mov	cx,ax
	sub	cx,bx		{v CX je x2-x1}
        mov	si,ax
	mov	ax,dx
	mov	dx,MaxGx
	dec	dx
	imul	dx
	xchg	ax,si
        mov	di,dx
        xchg	ax,bx
	imul	y2
        add	si,ax
	adc	di,dx		{v DI:SI je x2*y1}
        mov	ax,bx
        imul	y1		{v DX:AX je x1*y2}
	sub	ax,si
        sbb	dx,di
        idiv	cx
	mov	y2,ax
	mov	ax,MaxGx
	dec	ax
	mov	x2,ax
        jmp	@@locl1

prohod: mov	x1,ax		;{prohod x1,x1  y1,y2}
        mov	y1,dx
	mov	x2,bx
        mov	y2,cx
@@locl1:mov	ax,x2
        mov	dx,y2
        mov	bx,x1
	mov	cx,y1

        or	cx,cx		{test pruseciku s primkou y=0}
	js	kory0
        or	dx,dx
        js	kory0
        cmp	cx,maxGy	{test pruseciku s primkou y=maxGy}
	jge	koryMax
	cmp	dx,maxGy
	jge	koryMax
        or	ax,ax		{test pruseciku s primkou x=0}
        js	korx0
        or	bx,bx
        js	korx0
	cmp	ax,maxGx	{test pruseciku s primkou y=maxGx}
	jge	korxMax
        cmp	bx,maxGx
        jg	korxMax

	mov	di,bx
        sub	di,ax
        jg	nekordx
	neg	di		;{v DI je delta x}
nekordx:mov	si,cx
        sub	si,dx
        jg	nekordy
        neg	si		;{v SI je delta y}
nekordy:cmp	di,si
        jl      verticl
        cmp     bx,ax
        jl	ho_kb
        xchg    ax,bx
        xchg	cx,dx
ho_kb:  mov	word ptr x1,bx  ;{pocatecni x souradnice}
	mov	ax,maxgX	;{urceni incr}
	cmp	dx,cx
	jg	ho_plus
        neg	ax
ho_plus:mov	incr,ax
	mov	ax,cx		;{v AX je x pocatku v v CX je y}
	imul	maxgX
	add	ax,bx           ;{v DX:AX je adresa}
        adc	dx,0
        mov	cx,di		;{v CX je dx}
	mov	di,ax		;{v DX:[ES:DI] je plna adresa - DI hotovo}
        mov	bx,si		;{v BX je dy}
	mov	si,dx		;{v SI je kompletni popis registru segmentu}

        mov	ax,bx
        sub     ax,cx
        add	ax,ax           ;{AX=2*(dy-dx)}
        mov	k2,ax
	add	ax,cx		;{v AX je p=2*dy-dx}
        mov	dx,bx
        add	dx,bx		;{v DX je k1=2*dy}
        mov	k1,dx

	inc	cx
dobrekl:mov	dx,maxgX	;{korekce na preteceni hrany v ose x}
        sub	dx,x1		;{pocatecni bod v x}
	cmp	dx,cx
        jg	ho_lopk
        mov	cx,dx

ho_lopk:mov	dx,si		;{hlavni generacni smycka vodorovne usecky}
	call	SetGrPage
        mov	bl,byte ptr color
ho_lop: mov	byte ptr ES:DI,bl
        mov	dx,di
	inc	di
	or	ax,ax		;{je AX>0}
	js	hol_pl
        add	ax,K2
        add	di,incr
        xor	dx,di
        jns	ho_nky		;{nutno prestrankovat VGA?}
	mov	dx,di
        and	dh,0C0h
        cmp	dh,080h
	je	ho_nky		;{falesny pretok}
        cmp	dh,040h
        je	ho_nky		;{falesny pretok}
        cmp	word ptr incr,0
        jg	hop_pl
	dec	si		;{predchozi stranka}
        loop	ho_lopk
        jmp	lineend
hol_pl: add	ax,K1
	xor	dx,di
        js	ho_cor		;{nutno prestrankovat VGA?}
ho_nky:	loop	ho_lop
        jmp	lineend
ho_cor: mov	dx,di
        and	dh,0C0h
        jnz	ho_nky		;{falesny pretok}
hop_pl: inc	si		;{nasledujici stranka}
        loop	ho_lopk
        jmp	lineend

verticl:cmp     dx,cx		;{algoritmus vertikalni cary}
        jg	ve_kb
        xchg    ax,bx
        xchg	cx,dx
ve_kb:  mov	word ptr y1,cx  ;{pocatecni y souradnice}
	mov	word ptr x1,bx  ;{pocatecni x souradnice}
	mov	incr,1		;{urceni incr}
	cmp	ax,bx
	jg	ve_plus
        mov	incr,-1
ve_plus:mov	ax,cx		;{v AX je x pocatku v v CX je y}
	imul	maxgX
        add	ax,bx           ;{v DX:AX je adresa}
        adc	dx,0
        mov	cx,si		;{v CX je dy}
	mov	si,dx		;{v SI je registru segmentu VGA}
        mov	bx,di		;{v BX je dx}
       	mov	di,ax		;{v DX:[ES:DI] je plna adresa - DI hotovo}

        mov	ax,bx
        sub     ax,cx
        add	ax,ax           ;{AX=2*(dx-dy)}
        mov	k2,ax
	add	ax,cx		;{v AX je p=2*dx-dy}
        mov	dx,bx
        add	dx,bx		;{v DX je k1=2*dx}
        mov	k1,dx

        inc	cx
	mov	dx,word ptr x1

vdobrek:mov	dx,maxgY	;{korekce na preteceni hrany v ose y}
        sub	dx,y1		;{pocatecni bod y}
        cmp	dx,cx
	jg	ve_lopk
        mov	cx,dx		;{korekce delky v ose y}

ve_lopk:mov	dx,si		;{hlavni generacni smycka svisle usecky}
	call	SetGrPage
        mov	bl,byte ptr color
ve_lop: mov	byte ptr ES:DI,bl
        mov	dx,di
	add	di,maxgX
	or	ax,ax		;{je AX>0}
	js	vel_pl
        add	ax,K2
        add	di,incr
        xor	dx,di
	js	ve_cor
        loop	ve_lop
        jmp	lineend
ve_cor: mov	dx,di		;{korekce pretoku segmentu VGA}
        and	dh,0C0h
	jnz	ve_nky		;{falesny pretok}
	inc	si
        loop	ve_lopk
	jmp	lineend
vel_pl: add	ax,K1
	xor	dx,di
	js	ve_cor		;{nutno prestrankovat VGA?}
ve_nky:	loop	ve_lop

lineend:pop	es		{konec line}

  end;
end;


Procedure _Circle(xs,ys,r:integer);
var x,y,p:integer;
label loop;
begin
	asm
	mov	cx,0  	{cx obsahuje X}
	mov	si,r    {si obsahuje Y}
	mov	bx,3
	sub	bx,si
	sub	bx,si   {bx obsahuje P}

LOOP:	mov	x,cx
	mov	y,si
	mov	p,bx


	mov	ax,Xs
	add	ax,cx
	push	ax
        mov	ax,Ys
        add	ax,si
        push	ax
        call	plot	;{XS+x Ys+y}
	mov	ax,Xs
        sub	ax,cx
        push	ax
        mov	ax,Ys
        add	ax,si
        push	ax
        call	plot	;{XS-x Ys+y}
        mov	ax,Xs
	add	ax,cx
        push	ax
        mov	ax,Ys
        sub	ax,si
        push	ax
        call	plot	;{XS+x Ys-y}
	mov	ax,Xs
        sub	ax,cx
        push	ax
        mov	ax,Ys
        sub	ax,si
	push	ax
        call	plot	;{XS-x Ys-y}
        mov	ax,Xs
        add	ax,si
        push	ax
        mov	ax,Ys
        add	ax,cx
        push	ax
	call	plot	;{XS+y Ys+x}
        mov	ax,Xs
        sub	ax,si
        push	ax
        mov	ax,Ys
        add	ax,cx
	push	ax
        call	plot	;{XS-y Ys+x}
        mov	ax,Xs
        add	ax,si
        push	ax
	mov	ax,Ys
        sub	ax,cx
        push	ax
        call	plot	;{XS+y Ys-x}
        mov	ax,Xs
        sub	ax,si
        push	ax
        mov	ax,Ys
	sub	ax,cx
        push	ax
        call	plot	;{XS-y Ys-x}

	mov	bx,p
        mov	si,y
	mov	cx,x

        mov	dx,cx
        cmp	bx,0
        jg	@@plus
	add	bx,6		{pro zaporna P}
	jmp	@@pm

@@plus: sub	dx,si           {pro kladna P}
	add	bx,10
        dec	si

@@pm:	shl	dx,2
	add	bx,dx

	inc	cx
	cmp	cx,si
	jle	LOOP
	end;
end;


{Nahraje bitmapu s transparentni barvy v 'transparent'}
Procedure _BitmapT(x,y,ddx,ddy:integer;bmp:pointer); assembler;
asm
	push	es
	push	ds

	mov	ax,VideoSegment
	mov	es,ax

	mov	ax,y
	cmp	ax,maxgY
        jg	@@endb
        cmp	ax,0
	jl	@@endb
	mov	di,x
        cmp	di,maxgX
	jg	@@endb
        cmp	di,0
        jl	@@endb
	mul	maxgX
	add	di,ax
	adc	dx,0

{$ifdef extendM1}
	call	SetGrPage
{$endif}

	mov	bx,maxgX
	mov	dh,byte ptr transparent
	add	bx,ddx
	inc	bx
	cld
	lds     si,bmp
@@loopy:mov	cx,ddx
	inc	cx


{--------------------------------------}
@Lopx2:	mov	ax,di		{prenos po Wordech}
	add	ax,cx
	jc	@@loopx			{pouze prenos po bytech}

@DX_Gr:	shr	cx,1
	jcxz	@EloopE

@loopEx:lodsw
	cmp	al,dh
	je	@pou_lo
	cmp	ah,dh
	je	@pou_hi
	stosw
@loe:	loop	@loopEx
@EloopE:mov	cx,ddx
	inc	cx
	and	cx,001b
	jz      @@py
	jmp     @@Loopx

@pou_lo:cmp	ah,dh		{ni byte je maskovn}
	je	@pou_no
	stosb
	inc	di
	jmp	@loe
@pou_no:add	di,2		{oba byte jsou maskovny}
	jmp	@loe

@pou_hi:inc	di		{vy byte je maskovn}
	mov	al,ah
	stosb
	jmp	@loe
{--------------------------------------} (* *)

@@loopx:lodsb
	cmp	al,dh
	je	@@netisk
	stosb
	cmp	di,0
	je	@posunseg

        loop	@@loopx
@@py:	sub	di,bx
        dec	ddy
	jne	@@loopy
        jmp	@@endb
@@netisk:inc	di
	loop	@@loopx
	jmp	@@py
@posunseg:
{$ifdef extendM1}
	pop	ax
	push	ds
        mov	ds,ax
	mov	dx,OldPage
        inc	dx
	call    SetGrPage
	mov	dh,byte ptr transparent
        pop	ax
	push	ds
        mov	ds,ax
{$endif}

	loop	@@loopx
        jmp	@@py

@@endb: pop	ds
	pop	es
end;

{Nahraje bitmapu bez transparentni barvy}
Procedure _Bitmap(x,y,ddx,ddy:integer;bmp:pointer); assembler;
asm
	push	es
	push	ds

	mov	ax,VideoSegment
	mov	es,ax

        mov	ax,y
        cmp	ax,maxgY
        jg	@@endb
        cmp	ax,0
        jl	@@endb
        mov	di,x
        cmp	di,maxgX
	jg	@@endb
        cmp	di,0
        jl	@@endb
	mul	maxgX
        add	di,ax
        adc	dx,0

{$ifdef extendM1}
	call	SetGrPage
{$endif}

	mov	bx,maxgX
	add	bx,ddx
	inc	bx
	cld
	lds     si,bmp
@@loopy:mov	cx,ddx
	inc	cx


{--------------------------------------}
@Lopx2:	mov	ax,di		{prenos po Wordech}
	add	ax,cx
	jc	@@loopx			{pouze prenos po bytech}

@DX_Gr:	shr	cx,1
	rep movsw
	mov	cx,ddx
	inc	cx
	and	cx,001b
	jz      @@py
{--------------------------------------} (* *)

@@loopx:movsb
	cmp	di,0
	je	@posunseg

	loop	@@loopx
@@py:	sub	di,bx
	dec	ddy
	jne	@@loopy
	jmp	@@endb
@@netisk:inc	di
	loop	@@loopx
	jmp	@@py
@posunseg:
{$ifdef extendM1}
	pop	ax
	push	ds
	mov	ds,ax
	mov	dx,OldPage
	inc	dx
	call    SetGrPage
	pop	ax
	push	ds
	mov	ds,ax
{$endif}

	loop	@@loopx
	jmp	@@py

@@endb: pop	ds
	pop	es
end;



Procedure _Bar(X0,Y0,X1,Y1:integer); assembler;
asm
        push	ds
	push	es
	mov	ax,VideoSegment
        mov	es,ax

	mov	ax,WmingX
	add	ax,X0
	mov	X0,ax

	mov	ax,WmingY
	add	ax,Y0
	mov	Y0,ax

{	mov	ax,Y0}
	mov	di,X0
        mul	maxgx
        add	di,ax
        adc	dx,0

{$ifdef extendM1}
        cmp	dx,OldPage
        je      @preskoc
	call	SetGrPage
@preskoc:
{$endif}                		{DL is page counter}
	mov	al,byte ptr color
        mov	ah,al
	mov	si,Y1			{SI is counter Y}
	sub	si,Y0
@loopY: mov	cx,X1			{CX is counter X}
	sub	cx,X0

{$ifdef extendM1}
        mov     bx,di
        add     bx,cx
        jnc	@NeZmenaStr

        mov     bx,di		{v BX je zbytek do 0xFFFF}
        neg	bx
        sub	cx,bx		{v CX je pokracovani od 0xFFFF do konce radky}
        xchg	cx,bx
        rep stosb
        mov	cx,bx

        inc	dx
        call	SetGrPage	{dodelej radek}

        rep stosb

        sub	di,X1		{compute next Line pointer}
        add	di,X0
        add	di,MaxgX
	jmp	@GoodPage
@NeZmenaStr:
{$endif}
        mov	ah,al
        shr	cx,1
	rep stosw		{don't change CY}
        jnc	@Nezbyva
        stosb

@Nezbyva:
	sub	di,X1		{compute next Line pointer}
        add	di,X0
        add	di,MaxgX

{$ifdef extendM1}	{Page must be changed}
	jnc	@GoodPage
	inc	dx
        call	SetGrPage
@GoodPage:
{$endif}
	dec	si
	jnz	@LoopY

@@endb:	pop	es
	pop	ds
end;

Function InitGraph256(mode:integer):integer; far;{flag inicializuje jakykoliv dostupny horsi rezim}
var Return:Byte;
    i,j,Flag:Byte;
begin
Flag:=Mode And $F0;
Mode:=Mode And $0F;
if mode>5 then Mode:=5;
j:=0;
if (Mode>0)and(Flag=0) then j:=Vrezimy[Mode-1]+1;
for i:=Vrezimy[Mode] downto j do
	begin
	Return:=SetVideoMode(VModes[i].BiosMode);
        if Return=0 then Break;
        end;
if Return=0 then
	begin
        Color:=15;BkColor:=0; {White/Black}
        GetGraphMode:=mode;
        SetGraphMode:=InitGraph256;
	ClearDevice:=_ClearDevice265;
	circle:=_circle;
	plot:=_plot;
	line:=_line;
	Bar:=_Bar;
	GetPixel:=_GetPixel;
	Bitmap:=_Bitmap;
        if VModes[i].BiosMode>=$100 then SetGrPage:=SetSvgaPage
				    else SetGrPage:=SetVgaPage;

	WmaxgX:=VModes[i].SizeX; {nastaveni rozliseni}
	WmaxgY:=VModes[i].SizeY;
	maxgx:=WmaxgX;
	maxgy:=WmaxgY;
        ColorPlanes:=8;
	WmingX:=0;
	WmingY:=0;
        DriverName:=addr(GrNameVga256);
	end;
InitGraph256:=Return;
end;

{---------konec procedury zavislych na rozliseni obrazovky vga256 ----------}
{$else}
Function InitGraph256(mode:integer):integer; far;
begin
 InitGraph256:=254;
end;
{$endif}


{$ifdef vgaTrueColor}
{>>>>>>>>>>>>-Procedury zavisle na rozliseni obrazovky vgaTrueColor -<<<<<<<<<<}
Procedure _ClearDevice_TC; far; assembler;	{meni AX,DI,DX}
label loopage,nezbyt;
asm
	push	es
	cld
	mov	ax,VideoSegment
	mov	es,ax

	mov	ax,maxgY
	add	ax,ax
	add	ax,ax		{ax:=4*MaxGY}
	mul	maxgX
	mov     cx,ax		{zacneme posledni strankou (neuplnou)}

        shr	cx,2
	jcxz	nezbyt
	

LooPage:
{$ifdef extendM1}
	mov	ax,dx
	call	SetGrPage
        mov	dx,ax
{$endif}
db 66h;	mov	ax,word ptr BkColor

        mov	di,0
db 66h;	rep stosw

nezbyt:	mov	cx,$4000
{$ifdef extendM1}
        dec	dl
	jns	loopage
{$endif}
	pop	es
end;


Procedure _plot_TC(x,y:integer); assembler;	{meni AX,DI,DX}
label mimo;
asm
	push	es
	mov	ax,VideoSegment
        mov	es,ax

        mov	ax,y
        cmp	ax,maxgY
        jg	mimo
	cmp	ax,0
        jl	mimo
        mov	di,x
	cmp	di,maxgX
        jg	mimo
        cmp	di,0
        jl	mimo
	mul	maxgX
	add	di,ax
	adc	dx,0		{dx:di = x+y*maxgX}

	add	di,di
	adc	dx,dx
	add	di,di
	adc	dx,dx		{dx:di = 4*(x+y*maxgX)}


{$ifdef extendM1}
	cmp	dx,OldPage
	je      @preskoc
	call	SetGrPage
@preskoc:
{$endif}
	mov	ax,word ptr color
        mov	dl,byte ptr color+2
        xchg	al,dl
	mov	word ptr es:di,ax
	mov	byte ptr es:[di+2],dl
mimo:	pop	es
end;

Function _GetPixel_TC(X,Y: Integer): Longint; assembler;	{meni AX,DI,DX}
label mimo;
asm
	push	es
	mov	dx,0
	mov	ax,VideoSegment
	mov	es,ax

        mov	al,byte ptr color
        mov	bx,y
        cmp	bx,maxgY
        jg	mimo
	cmp	bx,0
        jl	mimo
        mov	di,x
        cmp	di,maxgX
        jg	mimo
	cmp	di,0
        jl	mimo
        mov	ax,bx
	mul	maxgX
        add	di,ax
	adc	dx,0		{dx:di = x+y*maxgX}

	mov	ax,di
	add	di,ax
	adc	dx,0
	add	di,ax
	adc	dx,0		{dx:di = 3*(x+y*maxgX)}


{$ifdef extendM1}
	cmp	dx,OldPage
        je      @preskoc
	call	SetGrPage
@preskoc:
{$endif}
	mov	ax,word ptr es:di
	mov	dl,byte ptr es:di+2
mimo:   mov	dh,0
	pop	es
end;


{Nahraje bitmapu bez transparentni barvy}
Procedure _Bitmap_TC(x,y,ddx,ddy:integer;bmp:pointer); assembler;
asm
	push	es
	push	ds

	mov	ax,VideoSegment
	mov	es,ax

        mov	ax,y
        cmp	ax,maxgY
        jg	@@endb
        cmp	ax,0
        jl	@@endb
        mov	di,x
        cmp	di,maxgX
	jg	@@endb
        cmp	di,0
        jl	@@endb
	mul	maxgX
        add	di,ax
        adc	dx,0

        add	di,di
	adc	dx,dx
	add	di,di
	adc	dx,dx


{$ifdef extendM1}
	call	SetGrPage
{$endif}

	mov	bx,maxgX
	add	bx,ddx
	inc	bx
	cld
	lds     si,bmp
@@loopy:mov	cx,ddx
	inc	cx

@@loopx:lodsw
	mov     dh,al
	lodsb
	stosw
	mov	es:[di],dh
	add	di,2

	jc	@posunseg

	loop	@@loopx

@@py:	sub	di,bx
	dec	ddy
	jne	@@loopy
	jmp	@@endb
@@netisk:inc	di
	loop	@@loopx
	jmp	@@py
@posunseg:
{$ifdef extendM1}
	pop	ax
	push	ds
	mov	ds,ax
	mov	dx,OldPage
	inc	dx
	call    SetGrPage
	pop	ax
	push	ds
	mov	ds,ax
{$endif}

	loop	@@loopx
	jmp	@@py

@@endb: pop	ds
	pop	es
end;



Function InitGraphTrueColor(mode:integer):integer; far;{flag inicializuje jakykoliv dostupny horsi rezim}
var Return:Byte;
    i,j,Flag:Byte;
begin
Flag:=Mode And $F0;
Mode:=Mode And $0F;
if mode>1 then Mode:=1;
j:=0;
if (Mode>0)and(Flag=0) then j:=VrezimyTC[Mode-1]+1;
for i:=VrezimyTC[Mode] downto j do
	begin
	Return:=SetVideoMode(VModesTC[i].BiosMode);
	if Return=0 then Break;
	end;
if Return=0 then
	begin
	Color:=$00FFFFFF;BkColor:=0; {White/Black}
	GetGraphMode:=mode;
	SetGraphMode:=InitGraphTrueColor;
	ClearDevice:=_ClearDevice_TC;
	plot:=_plot_TC;
	GetPixel:=_GetPixel_TC;
	line:=linePas;
        Bitmap:=_Bitmap_TC;

	if VModesTC[i].BiosMode>=$100 then SetGrPage:=SetSvgaPage
				      else SetGrPage:=SetVgaPage;

	WmaxgX:=VModesTC[i].SizeX; {nastaveni rozliseni}
	WmaxgY:=VModesTC[i].SizeY;
	maxgx:=WmaxgX;
	maxgy:=WmaxgY;
	ColorPlanes:=24;
	WmingX:=0;
	WmingY:=0;
	DriverName:=addr(GrNameVgaTC);
	end;
InitGraphTrueColor:=Return;
end;

{-------konec procedury zavislych na rozliseni obrazovky vgaTrueColor --------}
{$else}
Function InitGraphTrueColor(mode:integer):integer; far;
begin
 InitGraphTrueColor:=254;
end;
{$endif}




{$ifdef HercMono}
{>>>>>>>>>>>>>>-Procedury zavisle na rozliseni obrazovky HercMono -<<<<<<<<<<<<}

Procedure _ClearDeviceHerc; far; assembler;
asm
        mov	es,segB000
        mov	di,0
        mov	cx,4000h
        mov	ax,0

        cld
        rep stosw
end;

Procedure _plotHerc(x,y:integer); assembler;
asm
	mov	es,segB000

        mov	ax,y
        mov	bx,x
        mov	dx,ax
        shr	ax,1
        shr	ax,1
        mov	cl,90
        mul	cl
        and	dx,3
	mov	cl,3
        ror	dx,cl
        mov	di,bx
        mov	cl,3
        shr	di,cl
        add	di,ax
        add	di,dx
        mov	cl,7
        and	bx,7
	sub	cl,bl
        mov	ah,1
        shl	ah,cl
        or	es:[di],ah
end;

Function InitGraphHerc(m:integer):integer;  far;
const HercCrt:array[0..$B] of byte = ($35,$2d,$2e,$7,$5b,$2,$57,$57,$2,$3,0,0);
var retcode:integer;
begin
		asm
                push	ds

                mov	ds,seg0040
                mov	ax,-1
		cmp	byte ptr ds:[$49],7
                jne	@nechytil

		mov	al,3
		mov	dx,3BFh
		out	dx,al			{; port 3BFh, Hercules config}
		mov	al,$a
		mov	dx,3B8h
		out	dx,al

		mov	si,offset HercCrt
                mov	ax,seg HercCrt
                mov	ds,ax
                mov	ah,0
		mov	cx,0Ch
@FillHCrt:	mov	dx,3B4h
		mov	al,ah
		out	dx,al
                inc	ah

		inc	dx
		lodsb
		out	dx,al
                loop	@FillHCrt

                mov	ax,0
@nechytil:	pop	ds

		mov	retcode,ax
		end;
if retcode=0 then
	begin
        Color:=1;BkColor:=0; {Mono}
        GetGraphMode:=0;
        SetGraphMode:=InitGraphHerc;
	ClearDevice:=_ClearDeviceHerc;
        plot:=_plotHerc;
        line:=linePas;

        WmaxgX:=720; {nastaveni rozliseni}
	WmaxgY:=348;
	maxgx:=WmaxgX;
	maxgy:=WmaxgY;
        ColorPlanes:=1;
	WmingX:=0;
	WmingY:=0;
        DriverName:=addr(GrNameHerc);
	end;
InitGraphHerc:=RetCode;
end;



{---------konec procedury zavislych na rozliseni obrazovky HercMono ----------}
{$else}
Function InitGraphHerc(m:integer):integer;  far;
begin
 InitGraphHerc:=254;
end;
{$endif}




Function InitGraph(driver,mode:integer;Path:String):Byte;{flag inicializuje jakykoliv dostupny horsi rezim}
var i:integer;
    result:integer;
label Hotovo;
begin
GrPath:=Path;
SetGraphMode:=NoOpF1;
if(length(path)>2)and(path[length(path)]<>'\') then Grpath:=Grpath+'\';

case abs(driver) of 7:Result:=InitGraphHerc(0);
		   11:Result:=InitGraph256(mode);
		   12:Result:=InitGraphTrueColor(mode);
                 else Result:=-128;
	    end;
if (Result=0)or(driver>0) then goto Hotovo;

Result:=InitGraph256(mode);	{trying to initialize some drivers}
if (Result=0) then goto Hotovo;
Result:=InitGraphHerc(0);
if (Result=0) then goto Hotovo;


Hotovo:
InitGraph:=Result;
MOveTo(0,0);
end;



Procedure CloseGraph;
begin
 RestoreCrtMode;

 DriverName:=nil;
 GetGraphMode:=-1;
 SetGraphMode:=NoOpF1;
end;


Procedure RestoreCrtMode;
begin
 ClearDevice:=NoOp0;
 Plot:=NoOp2;
 GetPixel:=NoOpF2;
 Line:=NoOp4;
 Circle:=NoOp3;
 Bar:=NoOp4;
 Bitmap:=NoOp5;

	asm
        mov	ax,3
        xor	bx,bx
        int	10h
        end;
end;



begin
	WmaxgX:=320;
	WmaxgY:=200;
	maxgx:=WmaxgX;
	maxgy:=WmaxgY;

	WmingX:=0;
	WmingY:=0;

        TextX:=10;TextY:=30;
	SizeTX:=1;SizeTY:=-1;
        
end.